

%Code compiled by Robert Aare on 01.11.2014 in Tartu University
%KMC surface data must be imported as a matrix from the coordinates file.
%The matrix must be given the variable name "frame".
%The function TriScatteredInterp may be removed in the future releases. In
%that case to be replaced with command "scatteredInterpolant". The code
%creates a symmetrical surface and then interpolates it and smoothens it
%using 2-dimensional convolution with respect to atom radius, the latter
%having been derived from the initial data. Then it creates a spreadsheet
%file in the worksheet folder under the name "pinnafail.txt", which can
%easily be imported to COMSOL Multiphysics.
a=frame(:,1);
b=frame(:,2);
c=frame(:,3);
iptsetpref('ImshowBorder','tight');
A(:,5)=a+max(a);
A(:,1)=a;
A(:,2)=a;
A(:,3)=a;
A(:,4)=a+max(a);
A(:,6)=a+max(a);
A(:,7)=a+2*max(a);
A(:,8)=a+2*max(a);
A(:,9)=a+2*max(a);
C(:,1)=c;
C(:,2)=c;
C(:,3)=c;
C(:,4)=c;
C(:,5)=c;
C(:,6)=c;
C(:,7)=c;
C(:,8)=c;
C(:,9)=c;
B1(:,1)=b;
B1(:,2)=b+max(b);
B1(:,3)=b+2*max(b);
B1(:,6)=b+2*max(b);
B1(:,9)=b+2*max(b);
B1(:,5)=b+max(b);
B1(:,8)=b+max(b);
B1(:,4)=b;
B1(:,7)=b;
A=reshape(A,22518,1);
C=reshape(C,22518,1);
B=reshape(B1,22518,1);
frame3(:,3)=C;
frame3(:,2)=B;
frame3(:,1)=A;
Surface=TriScatteredInterp(A,B,C);
[tt,qq]=meshgrid(0:0.5:max(A),0:0.5:max(B));
HH=Surface(tt,qq);
%Note that here in conv2 you may need to change the integers 23 to
%multipliers that apply to your specific simulation.25.11.2014
smoothened_surface=conv2(ones(23)/(23*23),HH);
SM=smoothened_surface(225:450,225:450);
smoothZ=reshape(SM,226*226,1);
[smoothX,smoothY]=meshgrid(1:1:226,1:1:226);
smoothX=reshape(smoothX,226*226,1);
smoothY=reshape(smoothY,226*226,1);
spread1(:,1)=smoothX;
spread1(:,2)=smoothY;
spread1(:,3)=smoothZ;
dlmwrite('pinnafail.txt',spread1,' ');
